// VCanDrv.h: interface for the CVCanDrv class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VCANDRV_H__17D0A8B5_4724_4195_B637_B24F83497F01__INCLUDED_)
#define AFX_VCANDRV_H__17D0A8B5_4724_4195_B637_B24F83497F01__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "windows.h"
#include "vcand.h"

#define VCAN_EVENT_DATA(ev) (rx.tagData.msg.data)
#define VCAN_EVENT_LEN(ev)	(rx.tagData.msg.dlc)
#define VCAN_EVENT_PLEN(ev) (&rx.tagData.msg.dlc)
#define VCAN_EVENT_ID(ev)	(rx.tagData.msg.id)
#define VCAN_EVENT_PID(ev)	(&rx.tagData.msg.id)
#define VCAN_EVENT_FLAGS(ev)	(rx.tagData.msg.flags)
#define VCAN_EVENT_PFLAGS(ev)	(&rx.tagData.msg.flags)

class CVCanDrv  
{
public:
	VportHandle m_hPort;
	Vaccess m_chMask;
	Vaccess m_chGranted;
	Vstatus m_lastError;
	HANDLE m_rxNotifyEv;	// event for RX notification
	BOOL m_rxEvOwner;		// self created event ?

public:
	static BOOL OpenDriver();
	static BOOL CloseDriver();

	BOOL OpenPort(LPCSTR userName, int channel, int rxQueueSize = 0x100);
	void ClosePort();

	BOOL SetBitrate(DWORD bitRate);
	BOOL SetChannelMode(BOOL tx, BOOL txrq);
	BOOL SetReceiveMode(BOOL errFrame, BOOL chipState);
	BOOL SetChannelAcceptance(DWORD id, DWORD mask);
	BOOL ActivateChannel();
	BOOL DeactivateChannel();
	
	
	// Additional
	BOOL SetChannelParams(VchipParams* pParams);

	
	
	
	// transmitting
	BOOL Transmit(DWORD id, void* data, int length, BYTE flags = 0);

	// revive operations
	BOOL SetNotification(int queueLevel, HANDLE hEvent = NULL, BOOL bAutoClose = TRUE);
	DWORD WaitForNotification(DWORD dwMilliseconds);
	int Receive(VCAN_EVENT* rxFrames, int rxCnt = 1);

	// queue
	int GetReceiveQueueLevel();
	BOOL FlushReceiveQueue();
	BOOL FlushTransmitQueue();

	BOOL IsOpen() {
		return m_hPort >= 0; }
	BOOL HasInitAccess() {
		return IsOpen() && m_chMask == m_chGranted; }

	Vstatus GetLastError() {
		return m_lastError; }
	char* GetErrorString(Vstatus err) {
		return ncdGetErrorString(err); }
	char* GetLastErrorString() {
		return ncdGetErrorString(m_lastError); }

protected:
	void CloseRxEvent();

public:
	CVCanDrv();
	virtual ~CVCanDrv();
};

#endif // !defined(AFX_VCANDRV_H__17D0A8B5_4724_4195_B637_B24F83497F01__INCLUDED_)
